/**
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */

( function( $ ) {
	// Site title and description.
	wp.customize( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-title a' ).text( to );
		} );
	} );
	wp.customize( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).text( to );
		} );
	} );

//Update the fixed sidebar in real time...
	wp.customize( 'sidebar_fixed', function( value ) {
    	value.bind( function( to ) {

        if ( 'fixed' === to ) {
			 if (document.documentElement.clientWidth > 1200) {
            $( '#site-nav' ).css({
                 position: 'fixed',
                 top: '0',
                 left: '0',
                 right: '0',
                 display: 'block !important',
                 z-index: '10000'
            });
            $( '#masthead' ).css({
                margin-top: '54px'
            });
        }
        }
    });

//Update the hide tagline in real time...
	wp.customize( 'hide_tagline', function( value ) {
    	value.bind( function( to ) {
        if ( 'hide_tagline' === to ) {
            $( '#site-title h2.site-description' ).css({
                 display: 'none',
                 #site-about 'padding-top: 25px'
            });        }
    });

});
} )( jQuery );