<?php
/**
 * Available Ubud Custom Widgets
 *
 * Learn more: http://codex.wordpress.org/Widgets_API#Developing_Widgets
 *
 * @package Ubud
 * @since Ubud 1.0
 */

/*-----------------------------------------------------------------------------------*/
/* Ubud Social Links Widget
/*-----------------------------------------------------------------------------------*/

 class ubud_sociallinks extends WP_Widget {

	public function __construct() {
		parent::__construct( 'ubud_sociallinks', __( 'Social Links (ubud)', 'ubud' ), array(
			'classname'   => 'widget_ubud_sociallinks',
			'description' => __( 'Show icons with links to your social profiles.', 'ubud' ),
		) );
	}

	function widget($args, $instance) {
		extract( $args );
		$title = $instance['title'];
		$twitter = $instance['twitter'];
		$facebook = $instance['facebook'];
		$googleplus = $instance['googleplus'];
		$appnet = $instance['appnet'];
		$flickr = $instance['flickr'];
		$instagram = $instance['instagram'];
		$picasa = $instance['picasa'];
		$fivehundredpx = $instance['fivehundredpx'];
		$youtube = $instance['youtube'];
		$vimeo = $instance['vimeo'];
		$dribbble = $instance['dribbble'];
		$ffffound = $instance['ffffound'];
		$pinterest = $instance['pinterest'];
		$behance = $instance['behance'];
		$deviantart = $instance['deviantart'];
		$squidoo = $instance['squidoo'];
		$slideshare = $instance['slideshare'];
		$lastfm = $instance['lastfm'];
		$grooveshark = $instance['grooveshark'];
		$soundcloud = $instance['soundcloud'];
		$foursquare = $instance['foursquare'];
		$github = $instance['github'];
		$linkedin = $instance['linkedin'];
		$xing = $instance['xing'];
		$wordpress = $instance['wordpress'];
		$tumblr = $instance['tumblr'];
		$rss = $instance['rss'];
		$rsscomments = $instance['rsscomments'];

		echo $before_widget; ?>
		<?php if($title != '')
			echo '<h3 class="widget-title"><span>'. esc_html($title) .'</span></h3>'; ?>

        <ul class="sociallinks">
			<?php
			if($twitter != ''){
				echo '<li><a href="'.esc_url( $twitter ).'" class="twitter" title="' . __( 'Twitter', 'ubud' ) . '">' . __( 'Twitter', 'ubud' ) . '</a></li>';
			}
			?>

			<?php
			if($facebook != '') {
				echo '<li><a href="'.esc_url( $facebook ).'" class="facebook" title="' . __( 'Facebook', 'ubud' ) . '">' . __( 'Facebook', 'ubud' ) . '</a></li>';
			}
			?>

			<?php
			if($googleplus != '') {
				echo '<li><a href="'.esc_url( $googleplus ).'" class="googleplus" title="' . __( 'Google+', 'ubud' ) . '">' . __( 'Google+', 'ubud' ) . '</a></li>';
			}
			?>

			<?php
			if($appnet != '') {
				echo '<li><a href="'.esc_url( $appnet ).'" class="appnet" title="' . __( 'App.net', 'ubud' ) . '">' . __( 'App.net', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($flickr != '') {
				echo '<li><a href="'.esc_url( $flickr ).'" class="flickr" title="' . __( 'Flickr', 'ubud' ) . '">' . __( 'Flickr', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($instagram != '') {
				echo '<li><a href="'.esc_url( $instagram ).'" class="instagram" title="' . __( 'Instagram', 'ubud' ) . '">' . __( 'Instagram', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($picasa != '') {
				echo '<li><a href="'.esc_url( $picasa ).'" class="picasa" title="' . __( 'Picasa', 'ubud' ) . '">' . __( 'Picasa', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($fivehundredpx != '') {
				echo '<li><a href="'.esc_url( $fivehundredpx ).'" class="fivehundredpx" title="' . __( '500px', 'ubud' ) . '">' . __( '500px', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($youtube != '') {
				echo '<li><a href="'.esc_url( $youtube ).'" class="youtube" title="' . __( 'YouTube', 'ubud' ) . '">' . __( 'YouTube', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($vimeo != '') {
				echo '<li><a href="'.esc_url( $vimeo ).'" class="vimeo" title="' . __( 'Vimeo', 'ubud' ) . '">' . __( 'Vimeo', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($dribbble != '') {
				echo '<li><a href="'.esc_url( $dribbble ).'" class="dribbble" title="' . __( 'Dribbble', 'ubud' ) . '">' . __( 'Dribbble', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($ffffound != '') {
				echo '<li><a href="'.esc_url( $ffffound ).'" class="ffffound" title="' . __( 'Ffffound', 'ubud' ) . '">' . __( 'Ffffound', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($pinterest != '') {
				echo '<li><a href="'.esc_url( $pinterest ).'" class="pinterest" title="' . __( 'Pinterest', 'ubud' ) . '">' . __( 'Pinterest', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($behance != '') {
				echo '<li><a href="'.esc_url( $behance ).'" class="behance" title="' . __( 'Behance Network', 'ubud' ) . '">' . __( 'Behance Network', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($deviantart != '') {
				echo '<li><a href="'.esc_url( $deviantart ).'" class="deviantart" title="' . __( 'deviantART', 'ubud' ) . '">' . __( 'deviantART', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($squidoo != '') {
				echo '<li><a href="'.esc_url( $squidoo ).'" class="squidoo" title="' . __( 'Squidoo', 'ubud' ) . '">' . __( 'Squidoo', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($slideshare != '') {
				echo '<li><a href="'.esc_url( $slideshare ).'" class="slideshare" title="' . __( 'Slideshare', 'ubud' ) . '">' . __( 'Slideshare', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($lastfm != '') {
				echo '<li><a href="'.esc_url( $lastfm ).'" class="lastfm" title="' . __( 'Lastfm', 'ubud' ) . '">' . __( 'Lastfm', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($grooveshark != '') {
				echo '<li><a href="'.esc_url( $grooveshark ).'" class="grooveshark" title="' . __( 'Grooveshark', 'ubud' ) . '">' . __( 'Grooveshark', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($soundcloud != '') {
				echo '<li><a href="'.esc_url( $soundcloud ).'" class="soundcloud" title="' . __( 'Soundcloud', 'ubud' ) . '">' . __( 'Soundcloud', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($foursquare != '') {
				echo '<li><a href="'.esc_url( $foursquare ).'" class="foursquare" title="' . __( 'Foursquare', 'ubud' ) . '">' . __( 'Foursquare', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($github != '') {
				echo '<li><a href="'.esc_url( $github ).'" class="github" title="' . __( 'GitHub', 'ubud' ) . '">' . __( 'GitHub', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($linkedin != '') {
				echo '<li><a href="'.esc_url( $linkedin ).'" class="linkedin" title="' . __( 'LinkedIn', 'ubud' ) . '">' . __( 'LinkedIn', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($xing != '') {
				echo '<li><a href="'.esc_url( $xing ).'" class="xing" title="' . __( 'Xing', 'ubud' ) . '">' . __( 'Xing', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($wordpress != '') {
				echo '<li><a href="'.esc_url( $wordpress ).'" class="wordpress" title="' . __( 'WordPress', 'ubud' ) . '">' . __( 'WordPress', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($tumblr != '') {
				echo '<li><a href="'.esc_url( $tumblr ).'" class="tumblr" title="' . __( 'Tumblr', 'ubud' ) . '">' . __( 'Tumblr', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($rss != '') {
				echo '<li><a href="'.esc_url( $rss ).'" class="rss" title="' . __( 'RSS Feed', 'ubud' ) . '">' . __( 'RSS Feed', 'ubud' ) . '</a></li>';
			}
			?>

			<?php if($rsscomments != '') {
				echo '<li><a href="'.esc_url( $rsscomments ).'" class="rsscomments" title="' . __( 'RSS Comments', 'ubud' ) . '">' . __( 'RSS Comments', 'ubud' ) . '</a></li>';
			}
			?>

		</ul><!-- end .sociallinks -->

	   <?php
	   echo $after_widget;

	   // Reset the post globals as this query will have stomped on it
	   wp_reset_postdata();

   }

   function update($new_instance, $old_instance) {
       return $new_instance;
   }

   function form($instance) {
		$title = esc_attr($instance['title']);
		$twitter = esc_attr($instance['twitter']);
		$facebook = esc_attr($instance['facebook']);
		$googleplus = esc_attr($instance['googleplus']);
		$appnet = esc_attr($instance['appnet']);
		$flickr = esc_attr($instance['flickr']);
		$instagram = esc_attr($instance['instagram']);
		$picasa = esc_attr($instance['picasa']);
		$fivehundredpx = esc_attr($instance['fivehundredpx']);
		$youtube = esc_attr($instance['youtube']);
		$vimeo = esc_attr($instance['vimeo']);
		$dribbble = esc_attr($instance['dribbble']);
		$ffffound = esc_attr($instance['ffffound']);
		$pinterest = esc_attr($instance['pinterest']);
		$behance = esc_attr($instance['behance']);
		$deviantart = esc_attr($instance['deviantart']);
		$squidoo = esc_attr($instance['squidoo']);
		$slideshare = esc_attr($instance['slideshare']);
		$lastfm = esc_attr($instance['lastfm']);
		$grooveshark = esc_attr($instance['grooveshark']);
		$soundcloud = esc_attr($instance['soundcloud']);
		$foursquare = esc_attr($instance['foursquare']);
		$github = esc_attr($instance['github']);
		$linkedin = esc_attr($instance['linkedin']);
		$xing = esc_attr($instance['xing']);
		$wordpress = esc_attr($instance['wordpress']);
		$tumblr = esc_attr($instance['tumblr']);
		$rss = esc_attr($instance['rss']);
		$rsscomments = esc_attr($instance['rsscomments']);

		?>

		 <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo esc_attr($title); ?>" class="widefat" id="<?php echo $this->get_field_id('title'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('twitter'); ?>"><?php _e('Twitter URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('twitter'); ?>" value="<?php echo $twitter; ?>" class="widefat" id="<?php echo $this->get_field_id('twitter'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('facebook'); ?>"><?php _e('Facebook URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('facebook'); ?>" value="<?php echo $facebook; ?>" class="widefat" id="<?php echo $this->get_field_id('facebook'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('googleplus'); ?>"><?php _e('Google+ URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('googleplus'); ?>" value="<?php echo $googleplus; ?>" class="widefat" id="<?php echo $this->get_field_id('googleplus'); ?>" />
        </p>

		  <p>
            <label for="<?php echo $this->get_field_id('appnet'); ?>"><?php _e('App.net URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('appnet'); ?>" value="<?php echo $appnet; ?>" class="widefat" id="<?php echo $this->get_field_id('appnet'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('flickr'); ?>"><?php _e('Flickr URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('flickr'); ?>" value="<?php echo $flickr; ?>" class="widefat" id="<?php echo $this->get_field_id('flickr'); ?>" />
        </p>

		 <p>
            <label for="<?php echo $this->get_field_id('instagram'); ?>"><?php _e('Instagram URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('instagram'); ?>" value="<?php echo $instagram; ?>" class="widefat" id="<?php echo $this->get_field_id('instagram'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('picasa'); ?>"><?php _e('Picasa URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('picasa'); ?>" value="<?php echo $picasa; ?>" class="widefat" id="<?php echo $this->get_field_id('picasa'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('fivehundredpx'); ?>"><?php _e('500px URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('fivehundredpx'); ?>" value="<?php echo $fivehundredpx; ?>" class="widefat" id="<?php echo $this->get_field_id('fivehundredpx'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('youtube'); ?>"><?php _e('YouTube URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('youtube'); ?>" value="<?php echo $youtube; ?>" class="widefat" id="<?php echo $this->get_field_id('youtube'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('vimeo'); ?>"><?php _e('Vimeo URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('vimeo'); ?>" value="<?php echo $vimeo; ?>" class="widefat" id="<?php echo $this->get_field_id('vimeo'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('dribbble'); ?>"><?php _e('Dribbble URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('dribbble'); ?>" value="<?php echo $dribbble; ?>" class="widefat" id="<?php echo $this->get_field_id('dribbble'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('ffffound'); ?>"><?php _e('Ffffound URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('ffffound'); ?>" value="<?php echo $ffffound; ?>" class="widefat" id="<?php echo $this->get_field_id('ffffound'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('pinterest'); ?>"><?php _e('Pinterest URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('pinterest'); ?>" value="<?php echo $pinterest; ?>" class="widefat" id="<?php echo $this->get_field_id('pinterest'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('behance'); ?>"><?php _e('Behance Network URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('behance'); ?>" value="<?php echo $behance; ?>" class="widefat" id="<?php echo $this->get_field_id('behance'); ?>" />
        </p>

		 <p>
            <label for="<?php echo $this->get_field_id('deviantart'); ?>"><?php _e('deviantART URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('deviantart'); ?>" value="<?php echo $deviantart; ?>" class="widefat" id="<?php echo $this->get_field_id('deviantart'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('squidoo'); ?>"><?php _e('Squidoo URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('squidoo'); ?>" value="<?php echo $squidoo; ?>" class="widefat" id="<?php echo $this->get_field_id('squidoo'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('slideshare'); ?>"><?php _e('Slideshare URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('slideshare'); ?>" value="<?php echo $slideshare; ?>" class="widefat" id="<?php echo $this->get_field_id('slideshare'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('lastfm'); ?>"><?php _e('Last.fm URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('lastfm'); ?>" value="<?php echo $lastfm; ?>" class="widefat" id="<?php echo $this->get_field_id('lastfm'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('grooveshark'); ?>"><?php _e('Grooveshark URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('grooveshark'); ?>" value="<?php echo $grooveshark; ?>" class="widefat" id="<?php echo $this->get_field_id('grooveshark'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('soundcloud'); ?>"><?php _e('Soundcloud URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('soundcloud'); ?>" value="<?php echo $soundcloud; ?>" class="widefat" id="<?php echo $this->get_field_id('soundcloud'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('foursquare'); ?>"><?php _e('Foursquare URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('foursquare'); ?>" value="<?php echo $foursquare; ?>" class="widefat" id="<?php echo $this->get_field_id('foursquare'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('github'); ?>"><?php _e('GitHub URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('github'); ?>" value="<?php echo $github; ?>" class="widefat" id="<?php echo $this->get_field_id('github'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('linkedin'); ?>"><?php _e('Linkedin URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('linkedin'); ?>" value="<?php echo $linkedin; ?>" class="widefat" id="<?php echo $this->get_field_id('linkedin'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('xing'); ?>"><?php _e('Xing URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('xing'); ?>" value="<?php echo $xing; ?>" class="widefat" id="<?php echo $this->get_field_id('xing'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('wordpress'); ?>"><?php _e('WordPress URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('wordpress'); ?>" value="<?php echo $wordpress; ?>" class="widefat" id="<?php echo $this->get_field_id('wordpress'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('tumblr'); ?>"><?php _e('Tumblr URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('tumblr'); ?>" value="<?php echo $tumblr; ?>" class="widefat" id="<?php echo $this->get_field_id('tumblr'); ?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('rss'); ?>"><?php _e('RSS-Feed URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('rss'); ?>" value="<?php echo $rss; ?>" class="widefat" id="<?php echo $this->get_field_id('rss'); ?>" />
        </p>

		<p>
            <label for="<?php echo $this->get_field_id('rsscomments'); ?>"><?php _e('RSS for Comments URL:','ubud'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('rsscomments'); ?>" value="<?php echo $rsscomments; ?>" class="widefat" id="<?php echo $this->get_field_id('rsscomments'); ?>" />
        </p>

		<?php
	}
}

register_widget('ubud_sociallinks');


/*-----------------------------------------------------------------------------------*/
/* Include Ubud About Widget
/*-----------------------------------------------------------------------------------*/

class ubud_about extends WP_Widget {
	
	public function __construct() {
		parent::__construct( 'ubud_about', __( 'About (ubud)', 'ubud' ), array(
			'classname'   => 'widget_ubud_about',
			'description' => __( 'About widget to include an intro text and profile picture in the header area of your Front Page (Please only use this widget in the About Header Widget Area).', 'ubud' ),
		) );
	}

	function widget($args, $instance) {
		extract( $args );
		$aboutintrotext = $instance['aboutintrotext'];
		$aboutfulltext = $instance['aboutfulltext'];
		$imageurl = $instance['imageurl'];
		$imagewidth = $instance['imagewidth'];
		$imageheight = $instance['imageheight'];
		$aboutimgcaption = $instance['aboutimgcaption'];

		echo $before_widget; ?>

		<div class="about-introtext">
			<?php echo wp_kses_post(wpautop($aboutintrotext)); ?>
		</div><!-- end .about-introtext -->

		<?php if($aboutfulltext != '') : ?>
			<a href="#" id="about-btn"><?php _e('more info','ubud'); ?></a>
		<div class="about-full">
			<div class="about-img-wrap">
				<img src="<?php echo esc_url($imageurl); ?>" width="<?php echo absint($imagewidth); ?>" height="<?php echo absint($imageheight); ?>" class="about-img">
				<?php if($aboutimgcaption != '') : ?>
					<p class="about-img-caption"><?php echo wp_kses_post($aboutimgcaption); ?></p>
				<?php endif; ?>
			</div>
			<div class="about-fulltext">
				<?php echo wp_kses_post(wpautop($aboutfulltext)); ?>
				<a href="#" id="close-btn"><?php _e('close','ubud'); ?></a>
			</div>
		</div><!-- end .about-full -->
		<?php endif; ?>

	   <?php
	   echo $after_widget;
   }

   function update($new_instance, $old_instance) {
       return $new_instance;
   }

   function form($instance) {
		$aboutintrotext = esc_attr($instance['aboutintrotext']);
		$aboutfulltext = esc_attr($instance['aboutfulltext']);
		$imageurl = esc_attr($instance['imageurl']);
		$imagewidth = esc_attr($instance['imagewidth']);
		$imageheight = esc_attr($instance['imageheight']);
		$aboutimgcaption = esc_attr($instance['aboutimgcaption']);

		?>

		<p>
			<label for="<?php echo $this->get_field_id('aboutintrotext'); ?>"><?php _e('Short About Intro Text:','ubud'); ?></label>
			<textarea name="<?php echo $this->get_field_name('aboutintrotext'); ?>" class="widefat" rows="6" cols="20" id="<?php echo $this->get_field_id('aboutintrotext'); ?>"><?php echo( $aboutintrotext ); ?></textarea>
        </p>

        <p>
			<label for="<?php echo $this->get_field_id('aboutfulltext'); ?>"><?php _e('Further About Text (hidden by default):','ubud'); ?></label>
			<textarea name="<?php echo $this->get_field_name('aboutfulltext'); ?>" class="widefat" rows="20" cols="20" id="<?php echo $this->get_field_id('aboutfulltext'); ?>"><?php echo( $aboutfulltext ); ?></textarea>
        </p>

        <p>
			 <label for="<?php echo $this->get_field_id('imageurl'); ?>"><?php _e('Image URL:','ubud'); ?></label>
			 <input type="text" name="<?php echo $this->get_field_name('imageurl'); ?>" value="<?php echo $imageurl; ?>" class="widefat" id="<?php echo $this->get_field_id('imageurl'); ?>" />
        </p>

		 <p>
			 <label for="<?php echo $this->get_field_id('imagewidth'); ?>"><?php _e('Image Width (e.g. 233):','ubud'); ?></label>
			 <input type="text" name="<?php echo $this->get_field_name('imagewidth'); ?>" value="<?php echo $imagewidth; ?>" class="widefat" id="<?php echo $this->get_field_id('imagewidth'); ?>" />
        </p>

		 <p>
			 <label for="<?php echo $this->get_field_id('imageheight'); ?>"><?php _e('Image Height (e.g. 233):','ubud'); ?></label>
			 <input type="text" name="<?php echo $this->get_field_name('imageheight'); ?>" value="<?php echo $imageheight; ?>" class="widefat" id="<?php echo $this->get_field_id('imageheight'); ?>" />
        </p>

        <p>
			<label for="<?php echo $this->get_field_id('aboutimgcaption'); ?>"><?php _e('About Image Caption Text:','ubud'); ?></label>
			<textarea name="<?php echo $this->get_field_name('aboutimgcaption'); ?>" class="widefat" rows="2" cols="20" id="<?php echo $this->get_field_id('aboutimgcaption'); ?>"><?php echo( $aboutimgcaption ); ?></textarea>
        </p>


		<?php
	}
}

register_widget('ubud_about');