<?php
/**
 * Ubud Theme Customizer
 *
 * @package Ubud
 * @since Ubud 1.0
 */

/**
 * Implement Theme Customizer additions and adjustments.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 *
 * @since Ubud 1.0
 */
function ubud_customize_register( $wp_customize ) {

	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	$wp_customize->add_section( 'ubud_themeoptions', array(
		'title'         => __( 'Theme Options', 'ubud' ),
		'priority'      => 135,
	) );

	// Add the custom settings and controls.
	$wp_customize->add_setting( 'hide_tagline', array(
		'default'       => '',
	) );

	$wp_customize->add_control( 'hide_tagline', array(
		'label'         => __( 'Hide Tagline only', 'ubud' ),
		'section'       => 'title_tagline',
		'type'          => 'checkbox',
	) );

	$wp_customize->add_setting( 'header_textcolor' , array(
    	'default'     => '#000',
		'transport'   => 'refresh',
	) );

	$wp_customize->add_setting( 'link_color' , array(
    	'default'     => '#000',
		'transport'   => 'refresh',
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'link_color', array(
		'label'        => __( 'Link Color', 'ubud' ),
		'section'    => 'colors',
		'settings'   => 'link_color',
	) ) );

	$wp_customize->add_setting( 'linkhover_color' , array(
    	'default'     => '#999',
		'transport'   => 'refresh',
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'linkhover_color', array(
		'label'        => __( 'Link Hover Color', 'ubud' ),
		'section'    => 'colors',
		'settings'   => 'linkhover_color',
	) ) );

	$wp_customize->add_setting( 'footerbg_color' , array(
    	'default'     => '#000',
		'transport'   => 'refresh',
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footerbg_color', array(
		'label'        => __( 'Footer Background Color', 'ubud' ),
		'section'    => 'colors',
		'settings'   => 'footerbg_color',
	) ) );

	$wp_customize->add_setting( 'grid', array(
		'default'       => '3-column',
		'sanitize_callback' => 'ubud_sanitize_grid',
	) );

	$wp_customize->add_control( 'grid', array(
		'label'         => __( 'Default Image Grid', 'ubud' ),
		'section'       => 'ubud_themeoptions',
		'type'          => 'select',
		'choices' 		=> array(
					'1-column'	=> __( '1-column', 'ubud' ),
					'2-column'	=> __( '2-column', 'ubud' ),
               		'3-column'	=> __( '3-column', 'ubud' ),
			   		'4-column' 	=> __( '4-column', 'ubud' ),
			   		'5-column' 	=> __( '5-column', 'ubud' ),
		),
		'priority'      => 1,
	) );

	$wp_customize->add_setting( 'thumbnailformat', array(
		'default'       => 'landscape',
		'sanitize_callback' => 'ubud_sanitize_thumbnailformat',
	) );

	$wp_customize->add_control( 'thumbnailformat', array(
		'label'         => __( 'Thumbnail Format', 'ubud' ),
		'section'       => 'ubud_themeoptions',
		'type'          => 'select',
		'choices' 		=> array(
               		'landscape'	=> __( 'Landscape', 'ubud' ),
               		'portrait'	=> __( 'Portrait', 'ubud' ),
			   		'square' 	=> __( 'Square', 'ubud' ),
		),
		'priority'      => 1,
	) );

	$wp_customize->add_setting( 'img_hovers', array(
        'default'		=> 'light',
        'sanitize_callback' => 'ubud_sanitize_imghovers',
	) );

	$wp_customize->add_control( 'img_hovers', array(
		'label'         => __( 'Image Hovers', 'ubud' ),
		'section'       => 'ubud_themeoptions',
		'type'          => 'radio',
		'choices' 		=> array(
				'light'	=>	__( 'light',   'ubud' ),
				'dark'		=>	__( 'dark',   'ubud' ),
		),
	) );

	$wp_customize->add_setting( 'sidebar_fixed', array(
        'default'		=> 'scroll',
        'sanitize_callback' => 'ubud_sanitize_sidebar',
	) );

	$wp_customize->add_control( 'sidebar_fixed', array(
		'label'         => __( 'Sidebar (fixed sidebar may only be visible on wide screens)', 'ubud' ),
		'section'       => 'ubud_themeoptions',
		'type'          => 'radio',
		'choices' 		=> array(
				'scroll'	=>	__( 'scroll',   'ubud' ),
				'fixed'		=>	__( 'fixed',   'ubud' ),
		),
	) );

	$wp_customize->add_setting( 'footer_text', array(
		'default'       => '',
	) );

	$wp_customize->add_control( 'footer_text', array(
		'label'         => __( 'Custom Footer Text', 'ubud' ),
		'section'       => 'ubud_themeoptions',
		'type'          => 'text',
	) );

	// Add the custom settings and controls.
	$wp_customize->add_setting( 'sharebtn', array(
		'default'       => '',
	) );

	$wp_customize->add_control( 'sharebtn', array(
		'label'         => __( 'Show Share Buttons on Single posts', 'ubud' ),
		'section'       => 'ubud_themeoptions',
		'type'          => 'checkbox',
	) );

}
add_action( 'customize_register', 'ubud_customize_register' );


/**
 * Sanitize the Grid Column values.
 */
function ubud_sanitize_grid( $grid ) {
	if ( ! in_array( $grid, array( '1-column', '2-column', '3-column', '3-column', '4-column', '5-column' ) ) ) {
		$grid = '3-column';
	}

	return $grid;
}

/**
 * Sanitize the Thumbnail Format values.
 */
function ubud_sanitize_thumbnailformat( $thumbnailformat ) {
	if ( ! in_array( $thumbnailformat, array( 'portrait', 'landscape', 'square' ) ) ) {
		$thumbnailformat = 'portrait';
	}

	return $thumbnailformat;
}

/**
 * Sanitize the Sidebar value.
 */
function ubud_sanitize_sidebar( $sidebar ) {
	if ( ! in_array( $sidebar, array( 'scroll', 'fixed' ) ) ) {
		$sidebar = 'scroll';
	}

	return $sidebar;
}

/**
 * Sanitize the Image Hover value.
 */
function ubud_sanitize_imghovers( $imghovers ) {
	if ( ! in_array( $imghovers, array( 'light', 'dark' ) ) ) {
		$imghovers = 'light';
	}

	return $imghovers;
}


/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function ubud_customize_preview_js() {
	wp_enqueue_script( 'ubud-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20131221', true );
}
add_action( 'customize_preview_init', 'ubud_customize_preview_js' );