<?php
/**
 * Ubud functions and definitions
 *
 * @package Ubud
 * @since Ubud 1.0
 */

/*-----------------------------------------------------------------------------------*/
/* Sets up the content width value based on the theme's design.
/*-----------------------------------------------------------------------------------*/

if ( ! isset( $content_width ) )
		$content_width = 1305;

/*-----------------------------------------------------------------------------------*/
/* Sets up theme defaults and registers support for various WordPress features.
/*-----------------------------------------------------------------------------------*/

function ubud_setup() {

	// Make Ubud available for translation. Translations can be added to the /languages/ directory.
	load_theme_textdomain( 'ubud', get_template_directory() . '/languages' );

	// Remove support form block widget screens.
	remove_theme_support( 'widgets-block-editor' );

	// Add support for Block Styles.
	add_theme_support( 'wp-block-styles' );

	// Add support for default editor Styles in new editor.
	add_theme_support('editor-styles');

	// Add support for wider content.
	add_theme_support( 'align-wide' );

	// Add support responsive embedded content.
	add_theme_support( 'responsive-embeds' );

	// Add support for editor font sizes.
	add_theme_support( 'editor-font-sizes', array(
		array(
			'name' => __( 'small', 'ubud' ),
			'shortName' => __( 'S', 'ubud' ),
			'size' => 13,
			'slug' => 'small'
		),
		array(
			'name' => __( 'regular', 'ubud' ),
			'shortName' => __( 'M', 'ubud' ),
			'size' => 16,
			'slug' => 'regular'
		),
		array(
			'name' => __( 'large', 'ubud' ),
			'shortName' => __( 'L', 'ubud' ),
			'size' => 18,
			'slug' => 'large'
		),
		array(
			'name' => __( 'larger', 'ubud' ),
			'shortName' => __( 'XL', 'ubud' ),
			'size' => 22,
			'slug' => 'larger'
		)
	) );

	// Disable custom editor font sizes.
	add_theme_support('disable-custom-font-sizes');

	// Add editor color palette.
	add_theme_support( 'editor-color-palette', array(
		array(
			'name' => __( 'black', 'ubud' ),
			'slug' => 'black',
			'color' => '#000000',
		),
		array(
			'name' => __( 'light grey', 'ubud' ),
			'slug' => 'light-grey',
			'color' => '#f4f4f4',
		),
		array(
			'name' => __( 'dark grey', 'ubud' ),
			'slug' => 'dark-grey',
			'color' => '#ccc',
		),
		array(
			'name' => __( 'white', 'ubud' ),
			'slug' => 'white',
			'color' => '#ffffff',
		),
		array(
			'name' => __( 'light yellow', 'ubud' ),
			'slug' => 'light-yellow',
			'color' => '#fef5e6',
		),
		array(
			'name' => __( 'dark yellow', 'ubud' ),
			'slug' => 'dark-yellow',
			'color' => '#f18e2b',
		),
		array(
			'name' => __( 'light red', 'ubud' ),
			'slug' => 'light-red',
			'color' => '#fdebe9',
		),
		array(
			'name' => __( 'dark red', 'ubud' ),
			'slug' => 'dark-red',
			'color' => '#e23e32',
		),
		array(
			'name' => __( 'light green', 'ubud' ),
			'slug' => 'light-green',
			'color' => '#edf6ea',
		),
		array(
			'name' => __( 'dark green', 'ubud' ),
			'slug' => 'dark-green',
			'color' => '#489130',
		),
		array(
			'name' => __( 'light blue', 'ubud' ),
			'slug' => 'light-blue',
			'color' => '#ecf7f8',
		),
		array(
			'name' => __( 'dark blue', 'ubud' ),
			'slug' => 'dark-blue',
			'color' => '#459baf',
		),
	) );

	// This theme styles the visual editor to resemble the theme style.
	add_editor_style( array( 'editor-style.css' ) );

	// Add default posts and comments RSS feed links to head
	add_theme_support( 'automatic-feed-links' );

	// Let WordPress manage the document title.
	add_theme_support( 'title-tag' );

	// This theme uses wp_nav_menu().
	register_nav_menus( array (
		'primary' => __( 'Primary Navigation', 'ubud' ),
	) );

	// Implement the Custom Header feature
	require get_template_directory() . '/inc/custom-header.php';

	// This theme allows users to set a custom background.
	add_theme_support( 'custom-background', apply_filters( 'ubud_custom_background_args', array(
		'default-color'	=> 'fff',
		'default-image'	=> '',
	) ) );

	// This theme uses post thumbnails
	add_theme_support( 'post-thumbnails' );

	//  Adding additional sizes for Post Thumbnails
	add_image_size( 'img-square-big', 970, 970, true );
	add_image_size( 'img-portrait-big', 970, 1293, true );
	add_image_size( 'img-landscape-big', 970, 728, true );
	add_image_size( 'img-square', 700, 700, true );
	add_image_size( 'img-portrait', 700, 933, true );
	add_image_size( 'img-landscape', 700, 525, true );

}
add_action( 'after_setup_theme', 'ubud_setup' );


/*-----------------------------------------------------------------------------------*/
/*  Enqueue scripts and styles
/*-----------------------------------------------------------------------------------*/

function ubud_scripts() {
	global $wp_styles;

	// Loads JavaScript to pages with the comment form to support sites with threaded comments (when in use)
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
	wp_enqueue_script( 'comment-reply' );

	// Loads JavaScript for scalable videos
	wp_enqueue_script( 'ubud-cookie', get_template_directory_uri() . '/js/jquery.cookie.js', array( 'jquery' ), '1.4.0' );

	// Loads Custom Ubud JavaScript functionality
	wp_enqueue_script( 'ubud-script', get_template_directory_uri() . '/js/functions.js', array( 'jquery' ), '2014-02-20' );

	// Loads main stylesheet.
	wp_enqueue_style( 'ubud-style', get_stylesheet_uri(), array(), '2014-02-20' );

}
add_action( 'wp_enqueue_scripts', 'ubud_scripts' );


/*-----------------------------------------------------------------------------------*/
/* Get our wp_nav_menu() fallback, wp_page_menu(), to show a home link.
/*-----------------------------------------------------------------------------------*/

function ubud_page_menu_args( $args ) {
	$args['show_home'] = true;
	return $args;
}
add_filter( 'wp_page_menu_args', 'ubud_page_menu_args' );


/*-----------------------------------------------------------------------------------*/
/* Hide Pages from Search Results
/*-----------------------------------------------------------------------------------*/

function SearchFilter($query) {
if ($query->is_search) {
$query->set('post_type', 'post');
}
return $query;
}

add_filter('pre_get_posts','SearchFilter');


/*-----------------------------------------------------------------------------------*/
/* Get our wp_nav_menu() fallback, wp_page_menu(), to show a home link.
/*-----------------------------------------------------------------------------------*/
add_filter( 'wp_nav_menu_objects', 'add_menu_parent_class' );
function add_menu_parent_class( $items ) {

	$parents = array();
	foreach ( $items as $item ) {
		if ( $item->menu_item_parent && $item->menu_item_parent > 0 ) {
			$parents[] = $item->menu_item_parent;
		}
	}

	foreach ( $items as $item ) {
		if ( in_array( $item->ID, $parents ) ) {
			$item->classes[] = 'menu-parent-item';
		}
	}

	return $items;
}

/*-----------------------------------------------------------------------------------*/
/* Make new thumbnail sizes available in media library
/*-----------------------------------------------------------------------------------*/

add_filter( 'image_size_names_choose', 'ubud_custom_sizes' );

function ubud_custom_sizes( $sizes ) {
		return array_merge( $sizes, array(
				'ubud-recent-thumbnail' => __('Recent Post Thumbs', 'ubud' ),
		) );
}


/*-----------------------------------------------------------------------------------*/
/* Add Theme Customizer CSS
/*-----------------------------------------------------------------------------------*/

function ubud_customize_css() {
		?>
				 <style type="text/css">
			 <?php if ( 'fixed' === get_theme_mod( 'sidebar_fixed' ) ) { ?> @media screen and (min-width: 1200px) {
				 #site-nav { position: fixed; top: 0; left: 0; right: 0; display: block !important; z-index: 10000;}
				 #masthead {margin-top: 54px;}
				 .admin-bar #site-nav { top: 32px;}
				 .admin-bar #masthead {margin-top: 84px;}
			}
			<?php } ?>
			<?php if ( get_theme_mod( 'hide_tagline' ) != '' ) { ?>
				#site-title h2.site-description {display: none;}
				#site-about {padding-top: 25px;}
				@media screen and (min-width: 767px) {
					#site-about {padding-top: 40px;}
				}
			<?php } ?>
			a {color: <?php echo get_theme_mod('link_color'); ?>;}
			#site-about a#about-btn, #site-about a#close-btn, #infinite-handle span {border-bottom: 2px solid <?php echo get_theme_mod('link_color'); ?>;}
			#site-about a#about-btn:hover, #site-about a#close-btn:hover, #infinite-handle span:hover { color: <?php echo get_theme_mod('linkhover_color'); ?>; border-bottom: 2px solid <?php echo get_theme_mod('linkhover_color'); ?>;}
			.entry-header h2.entry-title a:hover, .entry-details a:hover, #comments a:hover, .author-info h6 a:hover, .post .entry-content a:hover, .page .entry-content a:hover, .about-introtext a:hover,.about-full a:hover,.textwidget a:hover,.single-post .author-info p.author-description a:hover {color: <?php echo get_theme_mod('linkhover_color'); ?>;}
			#colophon { background: <?php echo get_theme_mod('footerbg_color'); ?>;}
			<?php if ( 'dark' === get_theme_mod( 'img_hovers' ) ) { ?> @media screen and (min-width: 1200px) {
				 .site-content .post:hover .entry-thumbnail {background: #000;}
				 .search-results .site-content .page:hover .entry-thumbnail {background: #000;}
				 .site-content .post:hover .entry-thumbnail a.thumb-img {opacity: 0.7;}
				 .search-results .site-content .page:hover .entry-thumbnail a.thumb-img {opacity: 0.7;}
				 .entry-header h2.entry-title a, .entry-details, .entry-details a, .entry-details a:hover {color: rgba(255, 255, 255, 0.9);}
				 .list-view .entry-header h2.entry-title a, .list-view .entry-details, .list-view .entry-details a, .list-view .entry-details a:hover { color: #000;}
				 .entry-header h2.entry-title a:hover {color: #fff;}
				 .single-post .entry-details, .single-post .entry-details a {color: #000;}
				 .single-post .entry-details a:hover, .list-view .entry-header h2.entry-title a:hover {color: #999;}
			}
			<?php } ?>
				 </style>
		<?php
}
add_action( 'wp_head', 'ubud_customize_css');


/*-----------------------------------------------------------------------------------*/
/* Sets the post excerpt length to 15 characters.
/*-----------------------------------------------------------------------------------*/

function ubud_excerpt_length( $length ) {
	return 45;
}
add_filter( 'excerpt_length', 'ubud_excerpt_length' );


/*-----------------------------------------------------------------------------------*/
/* Remove inline styles printed when the gallery shortcode is used.
/*-----------------------------------------------------------------------------------*/

add_filter('use_default_gallery_style', '__return_false');

/**
 * Callback to change just html output on a comment.
 */
function ubud_comments_callback($comment, $args, $depth){
	//checks if were using a div or ol|ul for our output
	$tag = ( 'div' === $args['style'] ) ? 'div' : 'li';
	?>
	<<?php echo $tag; ?> id="comment-<?php comment_ID(); ?>" <?php comment_class( $args['has_children'] ? 'parent' : '', $comment ); ?>>
		<article id="comment-<?php comment_ID(); ?>" class="comment">

			<div class="comment-avatar">
				<?php echo get_avatar( $comment, 35 ); ?>
			</div>

			<div class="comment-details cf">
				<div class="comment-author">
					<?php printf( __( ' %s ', 'ubud' ), sprintf( ' %s ', get_comment_author_link() ) ); ?>
				</div><!-- end .comment-author -->
				<ul class="comment-meta">
					<li class="comment-time"><a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>">
						<?php
						/* translators: 1: date */
							printf( __( '%1$s', 'ubud' ),
							get_comment_date());
						?></a>
					</li>
					<?php if ( comments_open () ) : ?>
					<li class="comment-reply"><?php comment_reply_link( array_merge( $args, array( 'reply_text' => __( 'Reply', 'ubud' ), 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?></li>
					<?php endif; ?>
					<?php edit_comment_link( __( 'Edit', 'ubud' ));?>
				</ul><!-- end .comment-meta -->

			</div><!-- end .comment-details -->

				<div class="comment-text">
					<?php comment_text(); ?>
					<?php if ( $comment->comment_approved == '0' ) : ?>
						<p class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.', 'ubud' ); ?></p>
					<?php endif; ?>
				</div><!-- end .comment-text -->
		</article><!-- end .comment -->
	<?php
}


/*-----------------------------------------------------------------------------------*/
/* Register widgetized areas
/*-----------------------------------------------------------------------------------*/

function ubud_widgets_init() {

	register_sidebar( array (
		'name' => __( 'About Header Widget Area', 'ubud' ),
		'id' => 'sidebar-about',
		'description' => __( 'Widget area to include the About (Ubud) widget in the header area below the blog title. Please note that this widget area is only intended for the About (Ubud) widget.', 'ubud' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	register_sidebar( array (
		'name' => __( 'Footer Widget Area 1', 'ubud' ),
		'id' => 'footer-sidebar-1',
		'description' => __( 'Widgets will appear in the first footer column.', 'ubud' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	register_sidebar( array (
		'name' => __( 'Footer Widget Area 2', 'ubud' ),
		'id' => 'footer-sidebar-2',
		'description' => __( 'Widgets will appear in the second footer column.', 'ubud' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	register_sidebar( array (
		'name' => __( 'Footer Widget Area 3', 'ubud' ),
		'id' => 'footer-sidebar-3',
		'description' => __( 'Widgets will appear in the third footer column.', 'ubud' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	register_sidebar( array (
		'name' => __( 'Footer Widget Area 4', 'ubud' ),
		'id' => 'footer-sidebar-4',
		'description' => __( 'Widgets will appear in the fourth footer column.', 'ubud' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	register_sidebar( array (
		'name' => __( 'Social Links Footer Widget Area', 'ubud' ),
		'id' => 'footer-sidebar-social',
		'description' => __( 'Widget area to include the Social Links (Ubud) widget above the footer credit text. Please note that this widget area is only intended for the Social Links widget.', 'ubud' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

}
add_action( 'widgets_init', 'ubud_widgets_init' );


if ( ! function_exists( 'ubud_content_nav' ) ) :

/*-----------------------------------------------------------------------------------*/
/* Display navigation to next/previous pages when applicable
/*-----------------------------------------------------------------------------------*/

function ubud_content_nav( $nav_id ) {
	global $wp_query;

	if ( $wp_query->max_num_pages > 1 ) : ?>
		<div class="nav-wrap">
		<nav id="<?php echo $nav_id; ?>" class="cf">
				<div class="nav-previous"><?php next_posts_link( __( '<span>Older</span>', 'ubud'  ) ); ?></div>
				<div class="nav-next"><?php previous_posts_link( __( '<span>Newer</span>', 'ubud' ) ); ?></div>
			</nav>
		</div><!-- end .nav-wrap -->
	<?php endif;
}

endif; // ubud_content_nav


/*-----------------------------------------------------------------------------------*/
/* Extends the default WordPress body classes
/*-----------------------------------------------------------------------------------*/
function ubud_body_class( $classes ) {

	if (  '1-column' == get_theme_mod( 'grid' ) )
		$classes[] = 'one-column';

	if (  '2-column' == get_theme_mod( 'grid' ) )
		$classes[] = 'two-column';

	if (  '3-column' == get_theme_mod( 'grid' ) )
		$classes[] = 'three-column';

	if (  '4-column' == get_theme_mod( 'grid' ) )
		$classes[] = 'four-column';

	if (  '5-column' == get_theme_mod( 'grid' ) )
		$classes[] = 'five-column';

	if (  'landscape' == get_theme_mod( 'thumbnailformat' ) )
		$classes[] = 'landscape';

	if (  'portrait' == get_theme_mod( 'thumbnailformat' ) )
		$classes[] = 'portrait';

	if (  'square' == get_theme_mod( 'thumbnailformat' ) )
		$classes[] = 'square';

	if ( is_page_template( 'page-templates/full-width.php' ) )
		$classes[] = 'fullwidth';

	return $classes;
}
add_filter( 'body_class', 'ubud_body_class' );


/*-----------------------------------------------------------------------------------*/
/* Customizer additions
/*-----------------------------------------------------------------------------------*/
require get_template_directory() . '/inc/customizer.php';

/*-----------------------------------------------------------------------------------*/
/* Grab the Ubud Custom widgets.
/*-----------------------------------------------------------------------------------*/
require( get_template_directory() . '/inc/widgets.php' );

/*-----------------------------------------------------------------------------------*/
/* Grab the Ubud Custom shortcodes.
/*-----------------------------------------------------------------------------------*/
require( get_template_directory() . '/inc/shortcodes.php' );

/*-----------------------------------------------------------------------------------*/
/* Load Jetpack compatibility file.
/*-----------------------------------------------------------------------------------*/
require get_template_directory() . '/inc/jetpack.php';

/*-----------------------------------------------------------------------------------*/
/* Add One Click Demo Import code.
/*-----------------------------------------------------------------------------------*/
require get_template_directory() . '/inc/demo-installer.php';
