<?php
/**
 * The template for displaying the footer.
 *
 * @package Ubud
 * @since Ubud 1.0
 */
?>
</div><!-- end #main-wrap -->
</div><!-- end #container -->
<footer id="colophon" class="site-footer cf">

	<?php get_sidebar( 'footer' ); ?>

	<div id="site-info">

		<?php if ( is_active_sidebar( 'footer-sidebar-social' ) ) : ?>
			<div id="sidebar-footer-social" class="widget-area">
				<?php dynamic_sidebar( 'footer-sidebar-social' ); ?>
			</div><!-- .widget-area -->
		<?php endif; ?>

		<ul class="credit" role="contentinfo">
			<li class="wp-credit">
			<?php if ( get_theme_mod( 'footer_text' ) ) : ?>
				<?php echo wp_kses_post( get_theme_mod( 'footer_text' ) ); ?>
			<?php else : ?>
				<span class="copyright">&copy; <?php echo date('Y'); ?> <a href="<?php echo home_url( '/' ); ?>"><?php bloginfo(); ?></a></span>
				<span class="sep"> | </span>
				<?php
					/* Include Privacy Policy link. */
					if ( function_exists( 'the_privacy_policy_link' ) ) {
					the_privacy_policy_link( '<li>', '</li>', 'ubud');
					}
				?>
				<span class="sep"> | </span>
				<a href="https://wordpress.org/" rel="generator"><?php printf( __( 'Proudly powered by %s', 'ubud' ), 'WordPress' ); ?></a>
				<span class="sep"> | </span>
				<?php printf( __( 'Theme: %1$s by %2$s.', 'ubud' ), 'Ubud', '<a href="https://www.elmastudio.de/en/" rel="designer">Elmastudio</a>' ); ?>
			<?php endif; ?>
			</li>
		</ul><!-- end .credit -->

	</div><!-- end #site-info -->

</footer><!-- end #colophon -->

<?php if ( get_theme_mod( 'sharebtn' ) ) : ?>
<script type="text/javascript" src="https://platform.twitter.com/widgets.js"></script>
<script type="text/javascript">
(function() {
		window.PinIt = window.PinIt || { loaded:false };
		if (window.PinIt.loaded) return;
		window.PinIt.loaded = true;
		function async_load(){
				var s = document.createElement("script");
				s.type = "text/javascript";
				s.async = true;
				s.src = "https://assets.pinterest.com/js/pinit.js";
				var x = document.getElementsByTagName("script")[0];
				x.parentNode.insertBefore(s, x);
		}
		if (window.attachEvent)
				window.attachEvent("onload", async_load);
		else
				window.addEventListener("load", async_load, false);
})();
</script>
<?php endif; ?>

<?php wp_footer(); ?>

</body>
</html>
